/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.storage.StorageMap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemStackUtil {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final int DEFAULT_AMOUNT = 1;

    private ItemStackUtil() {
    }

    public static ItemStack fromStorage(StorageMap storage) {
        Material material;
        String materialString = (String)storage.getString("material").orElseThrow(() -> new BuildException("Missing \"material\" key in storage"));
        try {
            material = Material.valueOf((String)materialString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Could not find a material with the name: " + materialString);
        }
        int amount = storage.getInteger("amount").orElse(1);
        ItemStack item = new ItemStack(material, amount);
        storage.getString("display-name").ifPresent(displayName -> {
            Component displayNameComponent = MINI_MESSAGE.deserialize(displayName);
            item.editMeta(meta -> meta.displayName(displayNameComponent));
        });
        storage.getList("lore").ifPresent(storageList -> {
            ArrayList lore = new ArrayList();
            storageList.forEach(value -> {
                Component line;
                Object selector0$temp = value;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Number.class, Boolean.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        String string = (String)selector0$temp;
                        line = MINI_MESSAGE.deserialize((Object)string);
                        break;
                    }
                    case 1: {
                        Number number = (Number)selector0$temp;
                        line = Component.text((String)String.valueOf(number));
                        break;
                    }
                    case 2: {
                        Boolean bool = (Boolean)selector0$temp;
                        line = Component.text((boolean)bool);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                lore.add(line);
            });
            item.editMeta(meta -> meta.lore(lore));
        });
        return item;
    }
}

