/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper.action;

import java.util.Random;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.onestorm.plugins.stormregen.paper.action.Action;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemStackAction
implements Action {
    private static final Random RANDOM = new Random();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final double probability;
    private final boolean shouldSendMessage;
    private final String message;
    private final int minimumAmount;
    private final int maximumAmount;
    private final boolean dropItemStack;
    private final ItemStack itemStack;

    public ItemStackAction(double probability, boolean shouldSendMessage, String message, int minimumAmount, int maximumAmount, boolean dropItemStack, ItemStack itemStack) {
        this.probability = probability;
        this.shouldSendMessage = shouldSendMessage;
        this.message = message;
        this.minimumAmount = minimumAmount;
        this.maximumAmount = maximumAmount;
        this.dropItemStack = dropItemStack;
        this.itemStack = itemStack;
    }

    @Override
    public void execute(BlockState state, Player player) {
        if (!(this.probability >= 1.0) && !(Math.random() < this.probability)) {
            return;
        }
        int amount = this.minimumAmount < this.maximumAmount ? RANDOM.nextInt(this.minimumAmount, this.maximumAmount) : this.maximumAmount;
        this.itemStack.setAmount(amount);
        if (this.dropItemStack) {
            player.getWorld().dropItemNaturally(state.getLocation(), this.itemStack);
        } else {
            player.getInventory().addItem(new ItemStack[]{this.itemStack});
        }
        if (this.shouldSendMessage) {
            player.sendMessage(MINI_MESSAGE.deserialize((Object)this.message));
        }
    }
}

