/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Set;
import net.onestorm.plugins.stormregen.paper.StormRegen;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WorldGuardHandler
implements EventExecutor,
Listener {
    private final StormRegen plugin;

    public WorldGuardHandler(StormRegen plugin) {
        this.plugin = plugin;
    }

    public void handle(BreakBlockEvent event) {
        Event.Result originalResult = event.getResult();
        Object cause = event.getCause().getRootCause();
        if (cause instanceof Player) {
            Player player = (Player)cause;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            for (Block block : event.getBlocks()) {
                com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)block.getLocation());
                ApplicableRegionSet regionSet = container.createQuery().getApplicableRegions(location);
                Set materials = (Set)regionSet.queryValue((RegionAssociable)localPlayer, this.plugin.getAllowBlockBreakFlag());
                if (materials != null && materials.contains(block.getType())) {
                    event.setResult(Event.Result.ALLOW);
                    continue;
                }
                event.setResult(originalResult);
                break;
            }
        }
    }

    public void register(EventPriority priority) {
        this.plugin.getServer().getPluginManager().registerEvent(BreakBlockEvent.class, (Listener)this, priority, (EventExecutor)this, (Plugin)this.plugin, true);
    }

    public void execute(@NotNull Listener listener, @NotNull Event event) {
        this.handle((BreakBlockEvent)event);
    }
}

