/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormutils.paper.command;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.onestorm.plugins.stormutils.api.user.UtilUser;
import net.onestorm.plugins.stormutils.paper.StormUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;

public class WhoisCommand
extends BukkitCommand {
    private static final String COMMAND_NAME = "whois";
    private static final String COMMAND_PERMISSION = "stormutils.admin";
    private final StormUtils plugin;

    public WhoisCommand(StormUtils plugin) {
        super(COMMAND_NAME);
        this.plugin = plugin;
        this.setPermission(COMMAND_PERMISSION);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] arguments) {
        if (arguments.length != 1) {
            sender.sendMessage((Component)Component.text((String)"[!] Invalid command usage: /info <username>", (TextColor)NamedTextColor.RED));
            return true;
        }
        this.plugin.getUserManager().getUser(arguments[0]).thenAccept(optionalUser -> {
            if (optionalUser.isEmpty()) {
                sender.sendMessage((Component)Component.text((String)"[!] Could not find user.", (TextColor)NamedTextColor.RED));
                return;
            }
            UtilUser user = (UtilUser)optionalUser.get();
            try {
                this.plugin.getLogger().info("TEST: " + user.getLastKnownUsername() + " " + user.getFirstJoinTime() + " " + user.getLastJoinTime() + " " + user.getLastLogoutTime());
                sender.sendMessage(Component.text((String)"User Info:", (TextColor)NamedTextColor.DARK_AQUA).decoration(TextDecoration.BOLD, true));
                sender.sendMessage(Component.text((String)" Last known username: ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)user.getLastKnownUsername(), (TextColor)NamedTextColor.WHITE)));
                sender.sendMessage(Component.text((String)" First join time: ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)this.format(user.getFirstJoinTime()), (TextColor)NamedTextColor.WHITE)));
                sender.sendMessage(Component.text((String)" Last join time: ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)this.format(user.getLastJoinTime()), (TextColor)NamedTextColor.WHITE)));
                sender.sendMessage(Component.text((String)" Last logout time: ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)this.format(user.getLastLogoutTime()), (TextColor)NamedTextColor.WHITE)));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Uncaught exception in WhoisCommand#execute(...)", e);
            }
        });
        return true;
    }

    private String format(long time) {
        Instant instant = Instant.ofEpochMilli(time);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }
}

