/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormutils.paper.user;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.onestorm.plugins.stormutils.api.storage.UserData;
import net.onestorm.plugins.stormutils.api.user.OnlineUtilUser;
import net.onestorm.plugins.stormutils.api.user.UserManager;
import net.onestorm.plugins.stormutils.api.user.UtilUser;
import net.onestorm.plugins.stormutils.core.storage.UserDataImpl;
import net.onestorm.plugins.stormutils.paper.StormUtils;
import net.onestorm.plugins.stormutils.paper.user.OnlineUtilUserImpl;
import net.onestorm.plugins.stormutils.paper.user.UtilUserImpl;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class UserManagerImpl
implements UserManager,
Listener {
    private final Map<UUID, OnlineUtilUser> UuidToUserMap = new ConcurrentHashMap<UUID, OnlineUtilUser>();
    private final Map<String, OnlineUtilUser> UsernameToUserMap = new ConcurrentHashMap<String, OnlineUtilUser>();
    private final StormUtils plugin;

    public UserManagerImpl(StormUtils plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public Optional<OnlineUtilUser> getOnlineUser(UUID uuid) {
        return Optional.ofNullable(this.UuidToUserMap.get(uuid));
    }

    public Optional<OnlineUtilUser> getOnlineUser(String username) {
        return Optional.ofNullable(this.UsernameToUserMap.get(username.toLowerCase(Locale.ENGLISH)));
    }

    public List<OnlineUtilUser> getOnlineUsers() {
        return List.copyOf(this.UuidToUserMap.values());
    }

    public CompletableFuture<Optional<UtilUser>> getUser(UUID uuid) {
        UtilUser onlineUser = (UtilUser)this.UuidToUserMap.get(uuid);
        if (onlineUser != null) {
            return CompletableFuture.completedFuture(Optional.of(onlineUser));
        }
        CompletableFuture<Optional<UtilUser>> futureUser = new CompletableFuture<Optional<UtilUser>>();
        this.plugin.getStorage().getUserData(uuid).thenAccept(optionalUserData -> {
            if (optionalUserData.isEmpty()) {
                futureUser.complete(Optional.empty());
                return;
            }
            UtilUserImpl user = new UtilUserImpl(uuid);
            user.setUserData((UserData)optionalUserData.get());
            futureUser.complete(Optional.of(user));
        });
        return futureUser;
    }

    public CompletableFuture<Optional<UtilUser>> getUser(String username) {
        UtilUser onlineUser = (UtilUser)this.UsernameToUserMap.get(username.toLowerCase(Locale.ENGLISH));
        if (onlineUser != null) {
            return CompletableFuture.completedFuture(Optional.of(onlineUser));
        }
        CompletableFuture<Optional<UtilUser>> futureUser = new CompletableFuture<Optional<UtilUser>>();
        this.plugin.getStorage().getUserData(username).thenAccept(optionalUserData -> {
            if (optionalUserData.isEmpty()) {
                futureUser.complete(Optional.empty());
                return;
            }
            UserData userData = (UserData)optionalUserData.get();
            UtilUserImpl user = new UtilUserImpl(userData.getUuid());
            user.setUserData(userData);
            futureUser.complete(Optional.of(user));
        });
        return futureUser;
    }

    public void close() {
        long lastLogoutTime = System.currentTimeMillis();
        this.UuidToUserMap.forEach((uuid, user) -> {
            UserData userData = user.getUserData();
            if (userData == null) {
                return;
            }
            userData.setLastLogoutTime(lastLogoutTime);
            this.plugin.getStorage().setUserData(uuid, userData).thenAccept(unused -> userData.setSaved());
        });
        this.UuidToUserMap.clear();
        this.UsernameToUserMap.clear();
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        OnlineUtilUserImpl user = new OnlineUtilUserImpl(player);
        UUID uuid = user.getUuid();
        String username = user.getUsername().toLowerCase(Locale.ENGLISH);
        this.UuidToUserMap.put(uuid, user);
        this.UsernameToUserMap.put(username, user);
        CompletableFuture future = this.plugin.getStorage().getUserData(uuid);
        future.thenAccept(optionalUserData -> {
            UserData data;
            boolean newUser = false;
            if (optionalUserData.isPresent()) {
                System.out.println("present");
                data = (UserData)optionalUserData.get();
            } else {
                System.out.println("not present");
                data = new UserDataImpl(uuid);
                data.setFirstJoinTime(System.currentTimeMillis());
                newUser = true;
            }
            data.setLastKnownUsername(player.getName());
            data.setLastJoinTime(System.currentTimeMillis());
            user.setUserData(data);
            System.out.println("before: " + newUser);
            if (newUser) {
                System.out.println("before");
                CompletableFuture saveFuture = this.plugin.getStorage().setUserData(uuid, data);
                saveFuture.thenAccept(unused -> {
                    data.setSaved();
                    System.out.println("saved");
                });
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        OnlineUtilUser user = this.UuidToUserMap.remove(player.getUniqueId());
        if (user == null || this.plugin.isDisabling()) {
            return;
        }
        this.UsernameToUserMap.remove(user.getUsername().toLowerCase(Locale.ENGLISH));
        UserData data = user.getUserData();
        if (data == null) {
            return;
        }
        data.setLastLogoutTime(System.currentTimeMillis());
        this.plugin.getStorage().setUserData(user.getUuid(), data).thenAccept(unused -> data.setSaved());
    }
}

