/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormutils.paper;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import net.onestorm.library.action.ActionBuilder;
import net.onestorm.library.action.ActionManager;
import net.onestorm.library.action.ActionManagerImpl;
import net.onestorm.library.action.implementation.MessageActionBuilder;
import net.onestorm.library.paper.action.KillPlayerActionBuilder;
import net.onestorm.library.paper.action.PlaySoundActionBuilder;
import net.onestorm.library.requirement.RequirementBuilder;
import net.onestorm.library.requirement.RequirementManager;
import net.onestorm.library.requirement.RequirementManagerImpl;
import net.onestorm.library.requirement.implementation.PermissionRequirementBuilder;
import net.onestorm.library.storage.Storage;
import net.onestorm.library.storage.file.FileStorage;
import net.onestorm.library.storage.file.json.JsonStorage;
import net.onestorm.library.username.UsernameManager;
import net.onestorm.plugins.stormutils.api.UtilPlugin;
import net.onestorm.plugins.stormutils.api.storage.StorageManager;
import net.onestorm.plugins.stormutils.api.user.UserManager;
import net.onestorm.plugins.stormutils.core.storage.MongoStorageManager;
import net.onestorm.plugins.stormutils.paper.command.WhoisCommand;
import net.onestorm.plugins.stormutils.paper.user.UserManagerImpl;
import net.onestorm.plugins.stormutils.paper.username.UsernameManagerImpl;
import org.bukkit.command.Command;
import org.bukkit.plugin.java.JavaPlugin;

public class StormUtils
extends JavaPlugin
implements UtilPlugin {
    private final File configurationFile = new File(this.getDataFolder(), "configuration.json");
    private final FileStorage configuration = new JsonStorage();
    private StorageManager storageManager;
    private UserManager userManager;
    private UsernameManager usernameManager;
    private ActionManager actionManager;
    private RequirementManager requirementManager;
    private boolean isDisabling = false;

    public void onEnable() {
        this.isDisabling = false;
        this.reload();
        this.userManager = new UserManagerImpl(this);
        this.usernameManager = new UsernameManagerImpl(this);
        this.actionManager = new ActionManagerImpl(this.getLogger());
        this.actionManager.registerBuilder((ActionBuilder)new KillPlayerActionBuilder());
        this.actionManager.registerBuilder((ActionBuilder)new PlaySoundActionBuilder(this.getServer()));
        this.actionManager.registerBuilder((ActionBuilder)new MessageActionBuilder());
        this.requirementManager = new RequirementManagerImpl(this.getLogger());
        this.requirementManager.registerBuilder((RequirementBuilder)new PermissionRequirementBuilder());
        this.getServer().getCommandMap().register(this.getName().toLowerCase(Locale.ENGLISH), (Command)new WhoisCommand(this));
    }

    public void onDisable() {
        this.isDisabling = true;
        this.userManager.close();
        this.storageManager.close();
    }

    public Storage getConfiguration() {
        return this.configuration;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public UsernameManager getUsernameManager() {
        return this.usernameManager;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public RequirementManager getRequirementManager() {
        return this.requirementManager;
    }

    public boolean isDisabling() {
        return this.isDisabling;
    }

    public void reload() {
        if (!this.configurationFile.exists()) {
            this.saveResource("configuration.json", false);
        }
        try {
            this.configuration.load(this.configurationFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Could not load configuration file", e);
        }
        if (this.storageManager != null) {
            this.storageManager.close();
        }
        this.storageManager = new MongoStorageManager((UtilPlugin)this);
        this.storageManager.initialize();
    }
}

