/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormutils.paper.user;

import com.mongodb.client.model.ReplaceOptions;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import net.onestorm.plugins.stormutils.api.storage.UserStorage;
import net.onestorm.plugins.stormutils.api.user.OnlineUtilUser;
import net.onestorm.plugins.stormutils.api.user.UserManager;
import net.onestorm.plugins.stormutils.api.user.UtilUser;
import net.onestorm.plugins.stormutils.core.storage.UserStorageImpl;
import net.onestorm.plugins.stormutils.paper.StormUtils;
import net.onestorm.plugins.stormutils.paper.user.OnlineUtilUserImpl;
import net.onestorm.plugins.stormutils.paper.user.UtilUserImpl;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class UserManagerImpl
implements UserManager,
Listener {
    private static final int NUMBER_OF_THREADS = 1;
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private final Map<UUID, OnlineUtilUser> uuidToUserMap = new ConcurrentHashMap<UUID, OnlineUtilUser>();
    private final Map<String, OnlineUtilUser> usernameToUserMap = new ConcurrentHashMap<String, OnlineUtilUser>();
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions();
    private final StormUtils plugin;

    public UserManagerImpl(StormUtils plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public Optional<OnlineUtilUser> getOnlineUser(UUID uuid) {
        return Optional.ofNullable(this.uuidToUserMap.get(uuid));
    }

    public Optional<OnlineUtilUser> getOnlineUser(String username) {
        return Optional.ofNullable(this.usernameToUserMap.get(username.toLowerCase(Locale.ENGLISH)));
    }

    public List<OnlineUtilUser> getOnlineUsers() {
        return List.copyOf(this.uuidToUserMap.values());
    }

    public CompletableFuture<Optional<UtilUser>> getUser(UUID uuid) {
        UtilUser onlineUser = (UtilUser)this.uuidToUserMap.get(uuid);
        if (onlineUser != null) {
            return CompletableFuture.completedFuture(Optional.of(onlineUser));
        }
        CompletableFuture<Optional<UtilUser>> futureUser = new CompletableFuture<Optional<UtilUser>>();
        this.executor.submit(() -> {
            Optional optionalStorage = this.plugin.getStorageManager().getUserStorage(uuid);
            if (optionalStorage.isEmpty()) {
                futureUser.complete(Optional.empty());
                return;
            }
            UserStorage storage = (UserStorage)optionalStorage.get();
            UtilUserImpl user = new UtilUserImpl(uuid);
            user.setUserStorage(storage);
            futureUser.complete(Optional.of(user));
        });
        return futureUser;
    }

    public CompletableFuture<Optional<UtilUser>> getUser(String username) {
        UtilUser onlineUser = (UtilUser)this.usernameToUserMap.get(username.toLowerCase(Locale.ENGLISH));
        if (onlineUser != null) {
            return CompletableFuture.completedFuture(Optional.of(onlineUser));
        }
        CompletableFuture<Optional<UtilUser>> futureUser = new CompletableFuture<Optional<UtilUser>>();
        this.executor.submit(() -> {
            try {
                Optional optionalStorage = this.plugin.getStorageManager().getUserStorage(username);
                if (optionalStorage.isEmpty()) {
                    futureUser.complete(Optional.empty());
                    return;
                }
                UserStorage storage = (UserStorage)optionalStorage.get();
                Object value = storage.get("_id");
                if (!(value instanceof UUID)) {
                    this.plugin.getLogger().log(Level.WARNING, "_id is not a uuid");
                    futureUser.complete(Optional.empty());
                    return;
                }
                UUID uuid = (UUID)value;
                UtilUserImpl user = new UtilUserImpl(uuid);
                user.setUserStorage(storage);
                futureUser.complete(Optional.of(user));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Uncaught exception", e);
                futureUser.complete(Optional.empty());
            }
        });
        return futureUser;
    }

    public void close() {
        long time = System.currentTimeMillis();
        this.uuidToUserMap.forEach((uuid, user) -> {
            UserStorage userStorage = user.getUserStorage();
            if (userStorage == null) {
                this.plugin.getLogger().warning("User storage is null for: " + String.valueOf(user.getUuid()));
                return;
            }
            userStorage.set("last-logout-time", (Object)time);
            this.plugin.getStorageManager().setUserStorage(uuid, userStorage);
        });
        this.uuidToUserMap.clear();
        this.usernameToUserMap.clear();
        HandlerList.unregisterAll((Listener)this);
        this.executor.shutdown();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        OnlineUtilUserImpl user = new OnlineUtilUserImpl(player);
        UUID uuid = user.getUuid();
        String username = user.getUsername().toLowerCase(Locale.ENGLISH);
        this.uuidToUserMap.put(uuid, user);
        this.usernameToUserMap.put(username, user);
        long time = System.currentTimeMillis();
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
            UserStorageImpl storage;
            Optional optionalStorage = this.plugin.getStorageManager().getUserStorage(uuid);
            boolean newUser = false;
            if (optionalStorage.isEmpty()) {
                storage = new UserStorageImpl();
                newUser = true;
                storage.set("first-join-time", (Object)time);
                storage.set("uuid", (Object)uuid.toString());
            } else {
                storage = (UserStorage)optionalStorage.get();
            }
            storage.set("last-known-username", (Object)player.getName());
            storage.set("last-join-time", (Object)time);
            user.setUserStorage((UserStorage)storage);
            if (newUser) {
                this.plugin.getStorageManager().setUserStorage(uuid, (UserStorage)storage);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        OnlineUtilUser user = this.uuidToUserMap.remove(player.getUniqueId());
        if (user == null || this.plugin.isDisabling()) {
            return;
        }
        this.usernameToUserMap.remove(user.getUsername().toLowerCase(Locale.ENGLISH));
        UserStorage storage = user.getUserStorage();
        if (!(storage instanceof UserStorage)) {
            return;
        }
        UserStorage userStorage = storage;
        userStorage.set("last-logout-time", (Object)System.currentTimeMillis());
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.getStorageManager().setUserStorage(user.getUuid(), userStorage));
    }

    static {
        REPLACE_OPTIONS.upsert(true);
    }
}

